#!/bin/bash

module load anaconda/3
conda activate fairseq

src=$1
tgt=$2
type=$3
mode=$4
layers=$5
embdim=$6
ffndim=$7
attn_dim=$8
sdim=$9
heads=${10}
rules=${11}
lr=${12}
extras=${13}

ext=${extras//\-\-/\_}
ext=${ext// /}

base=$mode"_"$layers"_"$embdim"_"$ffndim

if [[ $type == "Stacked" ]]; then
  base="Stacked_"$base
  arch="transformer"
elif [[ $type == "Universal" ]]; then
  base="Universal_"$base
  arch="universal_transformer"
fi

base="iwslt16_"$src"-"$tgt"/"$base

if [[ $mode == "Compositional" ]]; then
	base=$base"_"$attn_dim"_"$sdim"_"$heads"_"$rules
elif [[ $mode == "Compositional_func" ]]; then
	base=$base"_"$attn_dim"_"$sdim"_"$heads"_"$rules
elif [[ $mode == "Standard" ]]; then
	base=$base"_"$heads
fi

base=$base"_"$lr

base=$base""$ext
mkdir -p "logs/iwslt16_"$src"-"$tgt"/"

name="checkpoints/"$base
tb="tensorboard/"$base
base="logs/"$base
wandb="NeurIPS-IWSLT16-"$src"-"$tgt

echo Running name is $name

PYTHONUNBUFFERED=1 python3 fairseq_cli/train.py \
    "data-bin/iwslt16.tokenized."$src"-"$tgt \
    --tensorboard-logdir $tb \
    --wandb-project $wandb \
    --arch $arch --share-decoder-input-output-embed \
    --encoder-embed-dim	$embdim \
    --encoder-ffn-embed-dim $ffndim \
    --decoder-embed-dim	$embdim \
    --decoder-ffn-embed-dim $ffndim \
    --encoder-layers $layers \
    --decoder-layers $layers \
    --encoder-attention-heads $heads \
    --decoder-attention-heads $heads \
    --attention-rules $rules \
    --attention-type $mode \
    --attn-dim $attn_dim \
    --selection-dim $sdim \
    $extras \
    --optimizer adam --adam-betas '(0.9, 0.98)' --clip-norm 0.0 \
    --lr $lr --lr-scheduler inverse_sqrt --warmup-updates 4000 \
    --dropout 0.3 --weight-decay 0.0001 \
    --criterion label_smoothed_cross_entropy --label-smoothing 0.1 \
    --max-tokens 4096 \
    --update-freq 8 \
    --max-epoch	100 \
    --eval-bleu \
    --eval-bleu-args '{"beam": 5, "max_len_a": 1.2, "max_len_b": 10}' \
    --eval-bleu-detok moses \
    --eval-bleu-remove-bpe \
    --eval-bleu-print-samples \
    --best-checkpoint-metric bleu --maximize-best-checkpoint-metric \
    --save-dir $name > $base".log"